package com.xforceplus.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jctke.entity.InvoiceOperationLog;
import com.xforceplus.jctke.service.IInvoiceOperationLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-01
 */
@RestController
public class InvoiceOperationLogController {

  @Autowired
  private IInvoiceOperationLogService invoiceOperationLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceOperationLog ${table.comment}
   * @return
   */
  @GetMapping("/invoiceoperationlogs" )
  public XfR getInvoiceOperationLogs(XfPage page, InvoiceOperationLog invoiceOperationLog) {
    return XfR.ok(invoiceOperationLogServiceImpl.page(page, Wrappers.query(invoiceOperationLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceoperationlogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceOperationLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceOperationLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoiceoperationlogs")
  public XfR save(@RequestBody InvoiceOperationLog invoiceOperationLog) {
     return XfR.ok(invoiceOperationLogServiceImpl.save(invoiceOperationLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceOperationLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoiceoperationlogs/{id}")
  public XfR putUpdate(@RequestBody InvoiceOperationLog invoiceOperationLog,@PathVariable Long id) {
      invoiceOperationLog.setId(id);
      return XfR.ok(invoiceOperationLogServiceImpl.updateById(invoiceOperationLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceOperationLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoiceoperationlogs/{id}")
  public XfR patchUpdate(@RequestBody InvoiceOperationLog invoiceOperationLog,@PathVariable Long id) {
      InvoiceOperationLog upinvoiceOperationLog = invoiceOperationLogServiceImpl.getById(id);
      if(upinvoiceOperationLog != null){
        upinvoiceOperationLog = ObjectCopyUtils.copyProperties(invoiceOperationLog,upinvoiceOperationLog,true);
      }
      return XfR.ok(invoiceOperationLogServiceImpl.updateById(upinvoiceOperationLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceoperationlogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceOperationLogServiceImpl.removeById(id));
  }

  @PostMapping("/invoiceoperationlogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_operation_log");
     params.put("request", condition);

     return XfR.ok(invoiceOperationLogServiceImpl.querys(params));
  }

}
