package com.xforceplus.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jctke.entity.PrepaymentWriteRelation;
import com.xforceplus.jctke.service.IPrepaymentWriteRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 外键为预付单id，用于聚合已核销金额前端控制器
 *
 * @author ultraman
 * @date 2022-12-01
 */
@RestController
public class PrepaymentWriteRelationController {

  @Autowired
  private IPrepaymentWriteRelationService prepaymentWriteRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param prepaymentWriteRelation 外键为预付单id，用于聚合已核销金额
   * @return
   */
  @GetMapping("/prepaymentwriterelations" )
  public XfR getPrepaymentWriteRelations(XfPage page, PrepaymentWriteRelation prepaymentWriteRelation) {
    return XfR.ok(prepaymentWriteRelationServiceImpl.page(page, Wrappers.query(prepaymentWriteRelation)));
  }

  /**
   * 通过id查询外键为预付单id，用于聚合已核销金额
   * @param  id
   * @return XfR
   */
  @GetMapping("/prepaymentwriterelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(prepaymentWriteRelationServiceImpl.getById(id));
  }

  /**
   * 新增外键为预付单id，用于聚合已核销金额
   * @param prepaymentWriteRelation 外键为预付单id，用于聚合已核销金额
   * @return XfR
   */
  @PostMapping("/prepaymentwriterelations")
  public XfR save(@RequestBody PrepaymentWriteRelation prepaymentWriteRelation) {
     return XfR.ok(prepaymentWriteRelationServiceImpl.save(prepaymentWriteRelation));
  }

  /**
   * 修改-传入修改后的全部数据外键为预付单id，用于聚合已核销金额
   * @param prepaymentWriteRelation 外键为预付单id，用于聚合已核销金额
   * @return XfR
   */
  @PutMapping("/prepaymentwriterelations/{id}")
  public XfR putUpdate(@RequestBody PrepaymentWriteRelation prepaymentWriteRelation,@PathVariable Long id) {
      prepaymentWriteRelation.setId(id);
      return XfR.ok(prepaymentWriteRelationServiceImpl.updateById(prepaymentWriteRelation));
  }

  /**
   * 修改-传入修改的数据外键为预付单id，用于聚合已核销金额
   * @param prepaymentWriteRelation 外键为预付单id，用于聚合已核销金额
   * @return XfR
   */
  @PatchMapping("/prepaymentwriterelations/{id}")
  public XfR patchUpdate(@RequestBody PrepaymentWriteRelation prepaymentWriteRelation,@PathVariable Long id) {
      PrepaymentWriteRelation upprepaymentWriteRelation = prepaymentWriteRelationServiceImpl.getById(id);
      if(upprepaymentWriteRelation != null){
        upprepaymentWriteRelation = ObjectCopyUtils.copyProperties(prepaymentWriteRelation,upprepaymentWriteRelation,true);
      }
      return XfR.ok(prepaymentWriteRelationServiceImpl.updateById(upprepaymentWriteRelation));
  }

  /**
   * 通过id删除外键为预付单id，用于聚合已核销金额
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/prepaymentwriterelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(prepaymentWriteRelationServiceImpl.removeById(id));
  }

  @PostMapping("/prepaymentwriterelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "prepayment_write_relation");
     params.put("request", condition);

     return XfR.ok(prepaymentWriteRelationServiceImpl.querys(params));
  }

}
