package com.xforceplus.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jctke.entity.PaymentPowerBiInit;
import com.xforceplus.jctke.service.IPaymentPowerBiInitService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-05-31
 */
@RestController
public class PaymentPowerBiInitController {

  @Autowired
  private IPaymentPowerBiInitService paymentPowerBiInitServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param paymentPowerBiInit ${table.comment}
   * @return
   */
  @GetMapping("/paymentpowerbiinits" )
  public XfR getPaymentPowerBiInits(XfPage page, PaymentPowerBiInit paymentPowerBiInit) {
    return XfR.ok(paymentPowerBiInitServiceImpl.page(page, Wrappers.query(paymentPowerBiInit)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/paymentpowerbiinits/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(paymentPowerBiInitServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param paymentPowerBiInit ${table.comment}
   * @return XfR
   */
  @PostMapping("/paymentpowerbiinits")
  public XfR save(@RequestBody PaymentPowerBiInit paymentPowerBiInit) {
     return XfR.ok(paymentPowerBiInitServiceImpl.save(paymentPowerBiInit));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param paymentPowerBiInit ${table.comment}
   * @return XfR
   */
  @PutMapping("/paymentpowerbiinits/{id}")
  public XfR putUpdate(@RequestBody PaymentPowerBiInit paymentPowerBiInit,@PathVariable Long id) {
      paymentPowerBiInit.setId(id);
      return XfR.ok(paymentPowerBiInitServiceImpl.updateById(paymentPowerBiInit));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param paymentPowerBiInit ${table.comment}
   * @return XfR
   */
  @PatchMapping("/paymentpowerbiinits/{id}")
  public XfR patchUpdate(@RequestBody PaymentPowerBiInit paymentPowerBiInit,@PathVariable Long id) {
      PaymentPowerBiInit uppaymentPowerBiInit = paymentPowerBiInitServiceImpl.getById(id);
      if(uppaymentPowerBiInit != null){
        uppaymentPowerBiInit = ObjectCopyUtils.copyProperties(paymentPowerBiInit,uppaymentPowerBiInit,true);
      }
      return XfR.ok(paymentPowerBiInitServiceImpl.updateById(uppaymentPowerBiInit));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/paymentpowerbiinits/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(paymentPowerBiInitServiceImpl.removeById(id));
  }

  @PostMapping("/paymentpowerbiinits/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "payment_power_bi_init");
     params.put("request", condition);

     return XfR.ok(paymentPowerBiInitServiceImpl.querys(params));
  }

}
