package com.xforceplus.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jctke.entity.ARPowerBiFailedHisTory;
import com.xforceplus.jctke.service.IARPowerBiFailedHisToryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-30
 */
@RestController
public class ARPowerBiFailedHisToryController {

  @Autowired
  private IARPowerBiFailedHisToryService ARPowerBiFailedHisToryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param aRPowerBiFailedHisTory ${table.comment}
   * @return
   */
  @GetMapping("/arpowerbifailedhistorys" )
  public XfR getARPowerBiFailedHisTorys(XfPage page, ARPowerBiFailedHisTory aRPowerBiFailedHisTory) {
    return XfR.ok(ARPowerBiFailedHisToryServiceImpl.page(page, Wrappers.query(aRPowerBiFailedHisTory)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/arpowerbifailedhistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ARPowerBiFailedHisToryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param aRPowerBiFailedHisTory ${table.comment}
   * @return XfR
   */
  @PostMapping("/arpowerbifailedhistorys")
  public XfR save(@RequestBody ARPowerBiFailedHisTory aRPowerBiFailedHisTory) {
     return XfR.ok(ARPowerBiFailedHisToryServiceImpl.save(aRPowerBiFailedHisTory));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param aRPowerBiFailedHisTory ${table.comment}
   * @return XfR
   */
  @PutMapping("/arpowerbifailedhistorys/{id}")
  public XfR putUpdate(@RequestBody ARPowerBiFailedHisTory aRPowerBiFailedHisTory,@PathVariable Long id) {
      aRPowerBiFailedHisTory.setId(id);
      return XfR.ok(ARPowerBiFailedHisToryServiceImpl.updateById(aRPowerBiFailedHisTory));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param aRPowerBiFailedHisTory ${table.comment}
   * @return XfR
   */
  @PatchMapping("/arpowerbifailedhistorys/{id}")
  public XfR patchUpdate(@RequestBody ARPowerBiFailedHisTory aRPowerBiFailedHisTory,@PathVariable Long id) {
      ARPowerBiFailedHisTory upaRPowerBiFailedHisTory = ARPowerBiFailedHisToryServiceImpl.getById(id);
      if(upaRPowerBiFailedHisTory != null){
        upaRPowerBiFailedHisTory = ObjectCopyUtils.copyProperties(aRPowerBiFailedHisTory,upaRPowerBiFailedHisTory,true);
      }
      return XfR.ok(ARPowerBiFailedHisToryServiceImpl.updateById(upaRPowerBiFailedHisTory));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/arpowerbifailedhistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ARPowerBiFailedHisToryServiceImpl.removeById(id));
  }

  @PostMapping("/arpowerbifailedhistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "a_r_power_bi_failed_his_tory");
     params.put("request", condition);

     return XfR.ok(ARPowerBiFailedHisToryServiceImpl.querys(params));
  }

}
