package com.xforceplus.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jctke.entity.AutoGoodsRecode;
import com.xforceplus.jctke.service.IAutoGoodsRecodeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 自动收货记录前端控制器
 *
 * @author ultraman
 * @date 2023-06-30
 */
@RestController
public class AutoGoodsRecodeController {

  @Autowired
  private IAutoGoodsRecodeService autoGoodsRecodeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param autoGoodsRecode 自动收货记录
   * @return
   */
  @GetMapping("/autogoodsrecodes" )
  public XfR getAutoGoodsRecodes(XfPage page, AutoGoodsRecode autoGoodsRecode) {
    return XfR.ok(autoGoodsRecodeServiceImpl.page(page, Wrappers.query(autoGoodsRecode)));
  }

  /**
   * 通过id查询自动收货记录
   * @param  id
   * @return XfR
   */
  @GetMapping("/autogoodsrecodes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(autoGoodsRecodeServiceImpl.getById(id));
  }

  /**
   * 新增自动收货记录
   * @param autoGoodsRecode 自动收货记录
   * @return XfR
   */
  @PostMapping("/autogoodsrecodes")
  public XfR save(@RequestBody AutoGoodsRecode autoGoodsRecode) {
     return XfR.ok(autoGoodsRecodeServiceImpl.save(autoGoodsRecode));
  }

  /**
   * 修改-传入修改后的全部数据自动收货记录
   * @param autoGoodsRecode 自动收货记录
   * @return XfR
   */
  @PutMapping("/autogoodsrecodes/{id}")
  public XfR putUpdate(@RequestBody AutoGoodsRecode autoGoodsRecode,@PathVariable Long id) {
      autoGoodsRecode.setId(id);
      return XfR.ok(autoGoodsRecodeServiceImpl.updateById(autoGoodsRecode));
  }

  /**
   * 修改-传入修改的数据自动收货记录
   * @param autoGoodsRecode 自动收货记录
   * @return XfR
   */
  @PatchMapping("/autogoodsrecodes/{id}")
  public XfR patchUpdate(@RequestBody AutoGoodsRecode autoGoodsRecode,@PathVariable Long id) {
      AutoGoodsRecode upautoGoodsRecode = autoGoodsRecodeServiceImpl.getById(id);
      if(upautoGoodsRecode != null){
        upautoGoodsRecode = ObjectCopyUtils.copyProperties(autoGoodsRecode,upautoGoodsRecode,true);
      }
      return XfR.ok(autoGoodsRecodeServiceImpl.updateById(upautoGoodsRecode));
  }

  /**
   * 通过id删除自动收货记录
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/autogoodsrecodes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(autoGoodsRecodeServiceImpl.removeById(id));
  }

  @PostMapping("/autogoodsrecodes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "auto_goods_recode");
     params.put("request", condition);

     return XfR.ok(autoGoodsRecodeServiceImpl.querys(params));
  }

}
