package com.xforceplus.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jctke.entity.AutoGoodsRecodeItem;
import com.xforceplus.jctke.service.IAutoGoodsRecodeItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-29
 */
@RestController
public class AutoGoodsRecodeItemController {

  @Autowired
  private IAutoGoodsRecodeItemService autoGoodsRecodeItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param autoGoodsRecodeItem ${table.comment}
   * @return
   */
  @GetMapping("/autogoodsrecodeitems" )
  public XfR getAutoGoodsRecodeItems(XfPage page, AutoGoodsRecodeItem autoGoodsRecodeItem) {
    return XfR.ok(autoGoodsRecodeItemServiceImpl.page(page, Wrappers.query(autoGoodsRecodeItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/autogoodsrecodeitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(autoGoodsRecodeItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param autoGoodsRecodeItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/autogoodsrecodeitems")
  public XfR save(@RequestBody AutoGoodsRecodeItem autoGoodsRecodeItem) {
     return XfR.ok(autoGoodsRecodeItemServiceImpl.save(autoGoodsRecodeItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param autoGoodsRecodeItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/autogoodsrecodeitems/{id}")
  public XfR putUpdate(@RequestBody AutoGoodsRecodeItem autoGoodsRecodeItem,@PathVariable Long id) {
      autoGoodsRecodeItem.setId(id);
      return XfR.ok(autoGoodsRecodeItemServiceImpl.updateById(autoGoodsRecodeItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param autoGoodsRecodeItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/autogoodsrecodeitems/{id}")
  public XfR patchUpdate(@RequestBody AutoGoodsRecodeItem autoGoodsRecodeItem,@PathVariable Long id) {
      AutoGoodsRecodeItem upautoGoodsRecodeItem = autoGoodsRecodeItemServiceImpl.getById(id);
      if(upautoGoodsRecodeItem != null){
        upautoGoodsRecodeItem = ObjectCopyUtils.copyProperties(autoGoodsRecodeItem,upautoGoodsRecodeItem,true);
      }
      return XfR.ok(autoGoodsRecodeItemServiceImpl.updateById(upautoGoodsRecodeItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/autogoodsrecodeitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(autoGoodsRecodeItemServiceImpl.removeById(id));
  }

  @PostMapping("/autogoodsrecodeitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "auto_goods_recode_item");
     params.put("request", condition);

     return XfR.ok(autoGoodsRecodeItemServiceImpl.querys(params));
  }

}
