package com.xforceplus.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jctke.entity.DeleteRecord;
import com.xforceplus.jctke.service.IDeleteRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-29
 */
@RestController
public class DeleteRecordController {

  @Autowired
  private IDeleteRecordService deleteRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param deleteRecord ${table.comment}
   * @return
   */
  @GetMapping("/deleterecords" )
  public XfR getDeleteRecords(XfPage page, DeleteRecord deleteRecord) {
    return XfR.ok(deleteRecordServiceImpl.page(page, Wrappers.query(deleteRecord)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/deleterecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(deleteRecordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param deleteRecord ${table.comment}
   * @return XfR
   */
  @PostMapping("/deleterecords")
  public XfR save(@RequestBody DeleteRecord deleteRecord) {
     return XfR.ok(deleteRecordServiceImpl.save(deleteRecord));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param deleteRecord ${table.comment}
   * @return XfR
   */
  @PutMapping("/deleterecords/{id}")
  public XfR putUpdate(@RequestBody DeleteRecord deleteRecord,@PathVariable Long id) {
      deleteRecord.setId(id);
      return XfR.ok(deleteRecordServiceImpl.updateById(deleteRecord));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param deleteRecord ${table.comment}
   * @return XfR
   */
  @PatchMapping("/deleterecords/{id}")
  public XfR patchUpdate(@RequestBody DeleteRecord deleteRecord,@PathVariable Long id) {
      DeleteRecord updeleteRecord = deleteRecordServiceImpl.getById(id);
      if(updeleteRecord != null){
        updeleteRecord = ObjectCopyUtils.copyProperties(deleteRecord,updeleteRecord,true);
      }
      return XfR.ok(deleteRecordServiceImpl.updateById(updeleteRecord));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/deleterecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(deleteRecordServiceImpl.removeById(id));
  }

  @PostMapping("/deleterecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "delete_record");
     params.put("request", condition);

     return XfR.ok(deleteRecordServiceImpl.querys(params));
  }

}
