package com.xforceplus.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jctke.entity.WeiAmountApproval;
import com.xforceplus.jctke.service.IWeiAmountApprovalService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-29
 */
@RestController
public class WeiAmountApprovalController {

  @Autowired
  private IWeiAmountApprovalService weiAmountApprovalServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param weiAmountApproval ${table.comment}
   * @return
   */
  @GetMapping("/weiamountapprovals" )
  public XfR getWeiAmountApprovals(XfPage page, WeiAmountApproval weiAmountApproval) {
    return XfR.ok(weiAmountApprovalServiceImpl.page(page, Wrappers.query(weiAmountApproval)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/weiamountapprovals/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(weiAmountApprovalServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param weiAmountApproval ${table.comment}
   * @return XfR
   */
  @PostMapping("/weiamountapprovals")
  public XfR save(@RequestBody WeiAmountApproval weiAmountApproval) {
     return XfR.ok(weiAmountApprovalServiceImpl.save(weiAmountApproval));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param weiAmountApproval ${table.comment}
   * @return XfR
   */
  @PutMapping("/weiamountapprovals/{id}")
  public XfR putUpdate(@RequestBody WeiAmountApproval weiAmountApproval,@PathVariable Long id) {
      weiAmountApproval.setId(id);
      return XfR.ok(weiAmountApprovalServiceImpl.updateById(weiAmountApproval));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param weiAmountApproval ${table.comment}
   * @return XfR
   */
  @PatchMapping("/weiamountapprovals/{id}")
  public XfR patchUpdate(@RequestBody WeiAmountApproval weiAmountApproval,@PathVariable Long id) {
      WeiAmountApproval upweiAmountApproval = weiAmountApprovalServiceImpl.getById(id);
      if(upweiAmountApproval != null){
        upweiAmountApproval = ObjectCopyUtils.copyProperties(weiAmountApproval,upweiAmountApproval,true);
      }
      return XfR.ok(weiAmountApprovalServiceImpl.updateById(upweiAmountApproval));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/weiamountapprovals/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(weiAmountApprovalServiceImpl.removeById(id));
  }

  @PostMapping("/weiamountapprovals/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "wei_amount_approval");
     params.put("request", condition);

     return XfR.ok(weiAmountApprovalServiceImpl.querys(params));
  }

}
