package com.xforceplus.jctraincuizhengtest.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.jctraincuizhengtest.entity.Fuleiobject002;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-08-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Zileiobject001 extends Fuleiobject002 {


  private String goodsName;

  private String goodsQuantity;

  private String goodsUnit;

  private BigDecimal itemWithTax;

  private BigDecimal itemWithoutTax;

  private BigDecimal itemTaxAmount;

  private String itemTaxRate;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("goods_name", goodsName);
      map.put("goods_quantity", goodsQuantity);
      map.put("goods_unit", goodsUnit);
      map.put("item_with_tax", itemWithTax);
      map.put("item_without_tax", itemWithoutTax);
      map.put("item_tax_amount", itemTaxAmount);
      map.put("item_tax_rate", itemTaxRate);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static Zileiobject001 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Zileiobject001 entity = new Zileiobject001();
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paper_drew_date")) {
      Object obj = map.get("paper_drew_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaperDrewDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPaperDrewDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaperDrewDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setPaperDrewDate(null);
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("origin_invoice_no")) {
      Object obj = map.get("origin_invoice_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_invoice_code")) {
      Object obj = map.get("origin_invoice_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_code")) {
      Object obj = map.get("bill_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_name")) {
      Object obj = map.get("goods_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_quantity")) {
      Object obj = map.get("goods_quantity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_unit")) {
      Object obj = map.get("goods_unit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_with_tax")) {
      Object obj = map.get("item_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setItemWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setItemWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setItemWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setItemWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setItemWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("item_without_tax")) {
      Object obj = map.get("item_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setItemWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setItemWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setItemWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setItemWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setItemWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("item_tax_amount")) {
      Object obj = map.get("item_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setItemTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setItemTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setItemTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setItemTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setItemTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("item_tax_rate")) {
      Object obj = map.get("item_tax_rate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
