package com.xforceplus.jctraincuizhengtest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizhengtest.entity.Zileiobject001;
import com.xforceplus.jctraincuizhengtest.service.IZileiobject001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-09
 */
@RestController
public class Zileiobject001Controller {

  @Autowired
  private IZileiobject001Service zileiobject001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param zileiobject001 ${table.comment}
   * @return
   */
  @GetMapping("/zileiobject001s" )
  public XfR getZileiobject001s(XfPage page, Zileiobject001 zileiobject001) {
    return XfR.ok(zileiobject001ServiceImpl.page(page, Wrappers.query(zileiobject001)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/zileiobject001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(zileiobject001ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param zileiobject001 ${table.comment}
   * @return XfR
   */
  @PostMapping("/zileiobject001s")
  public XfR save(@RequestBody Zileiobject001 zileiobject001) {
     return XfR.ok(zileiobject001ServiceImpl.save(zileiobject001));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param zileiobject001 ${table.comment}
   * @return XfR
   */
  @PutMapping("/zileiobject001s/{id}")
  public XfR putUpdate(@RequestBody Zileiobject001 zileiobject001,@PathVariable Long id) {
      zileiobject001.setId(id);
      return XfR.ok(zileiobject001ServiceImpl.updateById(zileiobject001));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param zileiobject001 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/zileiobject001s/{id}")
  public XfR patchUpdate(@RequestBody Zileiobject001 zileiobject001,@PathVariable Long id) {
      Zileiobject001 upzileiobject001 = zileiobject001ServiceImpl.getById(id);
      if(upzileiobject001 != null){
        upzileiobject001 = ObjectCopyUtils.copyProperties(zileiobject001,upzileiobject001,true);
      }
      return XfR.ok(zileiobject001ServiceImpl.updateById(upzileiobject001));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/zileiobject001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(zileiobject001ServiceImpl.removeById(id));
  }

  @PostMapping("/zileiobject001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "zileiobject001");
     params.put("request", condition);

     return XfR.ok(zileiobject001ServiceImpl.querys(params));
  }

}
