package com.xforceplus.jctraincuizheng2.controller;


/**
 * 多值枚举型feign客户端
 *
 * @author ultraman
 * @date 2022-01-22
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Autotestduozhimjx;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-train-cuizheng2")
public interface AutotestduozhimjxFeignApi {

  /**
   * 通过id查询多值枚举型
   * @param  id
   * @return R
   */
  @GetMapping("/autotestduozhimjx/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增多值枚举型
   * @param autotestduozhimjx 多值枚举型
   * @return R
   */
  @PostMapping("/autotestduozhimjx/add")
  public R save(@RequestBody Autotestduozhimjx autotestduozhimjx);

  /**
   * 修改多值枚举型
   * @param autotestduozhimjx 多值枚举型
   * @return R
   */
  @PostMapping("/autotestduozhimjx/update")
  public R updateById(@RequestBody Autotestduozhimjx autotestduozhimjx);

  /**
   * 通过id删除多值枚举型
   * @param  id
   * @return R
   */
  @DeleteMapping("/autotestduozhimjx/del/{id}" )
  public R removeById(@PathVariable Long id);

}