package com.xforceplus.jctraincuizheng2.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2022-01-22
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Privacy;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-train-cuizheng2")
public interface PrivacyFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/privacy/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param privacy ${table.comment}
   * @return R
   */
  @PostMapping("/privacy/add")
  public R save(@RequestBody Privacy privacy);

  /**
   * 修改${table.comment}
   * @param privacy ${table.comment}
   * @return R
   */
  @PostMapping("/privacy/update")
  public R updateById(@RequestBody Privacy privacy);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/privacy/del/{id}" )
  public R removeById(@PathVariable Long id);

}