package com.xforceplus.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Autotestchunszbh;
import com.xforceplus.jctraincuizheng2.service.IAutotestchunszbhService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * autotestchunszbh前端控制器
 *
 * @author ultraman
 * @date 2021-12-13
 */
@RestController
public class AutotestchunszbhController {

  @Autowired
  private IAutotestchunszbhService autotestchunszbhServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param autotestchunszbh autotestchunszbh
   * @return
   */
  @GetMapping("/autotestchunszbhs" )
  public XfR getAutotestchunszbhs(XfPage page, Autotestchunszbh autotestchunszbh) {
    return XfR.ok(autotestchunszbhServiceImpl.page(page, Wrappers.query(autotestchunszbh)));
  }

  /**
   * 通过id查询autotestchunszbh
   * @param  id
   * @return XfR
   */
  @GetMapping("/autotestchunszbhs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(autotestchunszbhServiceImpl.getById(id));
  }

  /**
   * 新增autotestchunszbh
   * @param autotestchunszbh autotestchunszbh
   * @return XfR
   */
  @PostMapping("/autotestchunszbhs")
  public XfR save(@RequestBody Autotestchunszbh autotestchunszbh) {
     return XfR.ok(autotestchunszbhServiceImpl.save(autotestchunszbh));
  }

  /**
   * 修改-传入修改后的全部数据autotestchunszbh
   * @param autotestchunszbh autotestchunszbh
   * @return XfR
   */
  @PutMapping("/autotestchunszbhs/{id}")
  public XfR putUpdate(@RequestBody Autotestchunszbh autotestchunszbh,@PathVariable Long id) {
      autotestchunszbh.setId(id);
      return XfR.ok(autotestchunszbhServiceImpl.updateById(autotestchunszbh));
  }

  /**
   * 修改-传入修改的数据autotestchunszbh
   * @param autotestchunszbh autotestchunszbh
   * @return XfR
   */
  @PatchMapping("/autotestchunszbhs/{id}")
  public XfR patchUpdate(@RequestBody Autotestchunszbh autotestchunszbh,@PathVariable Long id) {
      Autotestchunszbh upautotestchunszbh = autotestchunszbhServiceImpl.getById(id);
      if(upautotestchunszbh != null){
        upautotestchunszbh = ObjectCopyUtils.copyProperties(autotestchunszbh,upautotestchunszbh,true);
      }
      return XfR.ok(autotestchunszbhServiceImpl.updateById(upautotestchunszbh));
  }

  /**
   * 通过id删除autotestchunszbh
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/autotestchunszbhs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(autotestchunszbhServiceImpl.removeById(id));
  }

  @PostMapping("/autotestchunszbhs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "autotestchunszbh");
     params.put("request", condition);

     return XfR.ok(autotestchunszbhServiceImpl.querys(params));
  }

}
