package com.xforceplus.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Autotestobjectcode2;
import com.xforceplus.jctraincuizheng2.service.IAutotestobjectcode2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * autotestobjectcode2前端控制器
 *
 * @author ultraman
 * @date 2021-12-13
 */
@RestController
public class Autotestobjectcode2Controller {

  @Autowired
  private IAutotestobjectcode2Service autotestobjectcode2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param autotestobjectcode2 autotestobjectcode2
   * @return
   */
  @GetMapping("/autotestobjectcode2s" )
  public XfR getAutotestobjectcode2s(XfPage page, Autotestobjectcode2 autotestobjectcode2) {
    return XfR.ok(autotestobjectcode2ServiceImpl.page(page, Wrappers.query(autotestobjectcode2)));
  }

  /**
   * 通过id查询autotestobjectcode2
   * @param  id
   * @return XfR
   */
  @GetMapping("/autotestobjectcode2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(autotestobjectcode2ServiceImpl.getById(id));
  }

  /**
   * 新增autotestobjectcode2
   * @param autotestobjectcode2 autotestobjectcode2
   * @return XfR
   */
  @PostMapping("/autotestobjectcode2s")
  public XfR save(@RequestBody Autotestobjectcode2 autotestobjectcode2) {
     return XfR.ok(autotestobjectcode2ServiceImpl.save(autotestobjectcode2));
  }

  /**
   * 修改-传入修改后的全部数据autotestobjectcode2
   * @param autotestobjectcode2 autotestobjectcode2
   * @return XfR
   */
  @PutMapping("/autotestobjectcode2s/{id}")
  public XfR putUpdate(@RequestBody Autotestobjectcode2 autotestobjectcode2,@PathVariable Long id) {
      autotestobjectcode2.setId(id);
      return XfR.ok(autotestobjectcode2ServiceImpl.updateById(autotestobjectcode2));
  }

  /**
   * 修改-传入修改的数据autotestobjectcode2
   * @param autotestobjectcode2 autotestobjectcode2
   * @return XfR
   */
  @PatchMapping("/autotestobjectcode2s/{id}")
  public XfR patchUpdate(@RequestBody Autotestobjectcode2 autotestobjectcode2,@PathVariable Long id) {
      Autotestobjectcode2 upautotestobjectcode2 = autotestobjectcode2ServiceImpl.getById(id);
      if(upautotestobjectcode2 != null){
        upautotestobjectcode2 = ObjectCopyUtils.copyProperties(autotestobjectcode2,upautotestobjectcode2,true);
      }
      return XfR.ok(autotestobjectcode2ServiceImpl.updateById(upautotestobjectcode2));
  }

  /**
   * 通过id删除autotestobjectcode2
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/autotestobjectcode2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(autotestobjectcode2ServiceImpl.removeById(id));
  }

  @PostMapping("/autotestobjectcode2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "autotestobjectcode2");
     params.put("request", condition);

     return XfR.ok(autotestobjectcode2ServiceImpl.querys(params));
  }

}
