package com.xforceplus.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Autotestzfcjihe;
import com.xforceplus.jctraincuizheng2.service.IAutotestzfcjiheService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * autotestzfcjihe前端控制器
 *
 * @author ultraman
 * @date 2021-12-13
 */
@RestController
public class AutotestzfcjiheController {

  @Autowired
  private IAutotestzfcjiheService autotestzfcjiheServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param autotestzfcjihe autotestzfcjihe
   * @return
   */
  @GetMapping("/autotestzfcjihes" )
  public XfR getAutotestzfcjihes(XfPage page, Autotestzfcjihe autotestzfcjihe) {
    return XfR.ok(autotestzfcjiheServiceImpl.page(page, Wrappers.query(autotestzfcjihe)));
  }

  /**
   * 通过id查询autotestzfcjihe
   * @param  id
   * @return XfR
   */
  @GetMapping("/autotestzfcjihes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(autotestzfcjiheServiceImpl.getById(id));
  }

  /**
   * 新增autotestzfcjihe
   * @param autotestzfcjihe autotestzfcjihe
   * @return XfR
   */
  @PostMapping("/autotestzfcjihes")
  public XfR save(@RequestBody Autotestzfcjihe autotestzfcjihe) {
     return XfR.ok(autotestzfcjiheServiceImpl.save(autotestzfcjihe));
  }

  /**
   * 修改-传入修改后的全部数据autotestzfcjihe
   * @param autotestzfcjihe autotestzfcjihe
   * @return XfR
   */
  @PutMapping("/autotestzfcjihes/{id}")
  public XfR putUpdate(@RequestBody Autotestzfcjihe autotestzfcjihe,@PathVariable Long id) {
      autotestzfcjihe.setId(id);
      return XfR.ok(autotestzfcjiheServiceImpl.updateById(autotestzfcjihe));
  }

  /**
   * 修改-传入修改的数据autotestzfcjihe
   * @param autotestzfcjihe autotestzfcjihe
   * @return XfR
   */
  @PatchMapping("/autotestzfcjihes/{id}")
  public XfR patchUpdate(@RequestBody Autotestzfcjihe autotestzfcjihe,@PathVariable Long id) {
      Autotestzfcjihe upautotestzfcjihe = autotestzfcjiheServiceImpl.getById(id);
      if(upautotestzfcjihe != null){
        upautotestzfcjihe = ObjectCopyUtils.copyProperties(autotestzfcjihe,upautotestzfcjihe,true);
      }
      return XfR.ok(autotestzfcjiheServiceImpl.updateById(upautotestzfcjihe));
  }

  /**
   * 通过id删除autotestzfcjihe
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/autotestzfcjihes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(autotestzfcjiheServiceImpl.removeById(id));
  }

  @PostMapping("/autotestzfcjihes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "autotestzfcjihe");
     params.put("request", condition);

     return XfR.ok(autotestzfcjiheServiceImpl.querys(params));
  }

}
