package com.xforceplus.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Autotestapishitu;
import com.xforceplus.jctraincuizheng2.service.IAutotestapishituService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * autotestapishitu前端控制器
 *
 * @author ultraman
 * @date 2022-01-07
 */
@RestController
public class AutotestapishituController {

  @Autowired
  private IAutotestapishituService autotestapishituServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param autotestapishitu autotestapishitu
   * @return
   */
  @GetMapping("/autotestapishitus" )
  public XfR getAutotestapishitus(XfPage page, Autotestapishitu autotestapishitu) {
    return XfR.ok(autotestapishituServiceImpl.page(page, Wrappers.query(autotestapishitu)));
  }

  /**
   * 通过id查询autotestapishitu
   * @param  id
   * @return XfR
   */
  @GetMapping("/autotestapishitus/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(autotestapishituServiceImpl.getById(id));
  }

  /**
   * 新增autotestapishitu
   * @param autotestapishitu autotestapishitu
   * @return XfR
   */
  @PostMapping("/autotestapishitus")
  public XfR save(@RequestBody Autotestapishitu autotestapishitu) {
     return XfR.ok(autotestapishituServiceImpl.save(autotestapishitu));
  }

  /**
   * 修改-传入修改后的全部数据autotestapishitu
   * @param autotestapishitu autotestapishitu
   * @return XfR
   */
  @PutMapping("/autotestapishitus/{id}")
  public XfR putUpdate(@RequestBody Autotestapishitu autotestapishitu,@PathVariable Long id) {
      autotestapishitu.setId(id);
      return XfR.ok(autotestapishituServiceImpl.updateById(autotestapishitu));
  }

  /**
   * 修改-传入修改的数据autotestapishitu
   * @param autotestapishitu autotestapishitu
   * @return XfR
   */
  @PatchMapping("/autotestapishitus/{id}")
  public XfR patchUpdate(@RequestBody Autotestapishitu autotestapishitu,@PathVariable Long id) {
      Autotestapishitu upautotestapishitu = autotestapishituServiceImpl.getById(id);
      if(upautotestapishitu != null){
        upautotestapishitu = ObjectCopyUtils.copyProperties(autotestapishitu,upautotestapishitu,true);
      }
      return XfR.ok(autotestapishituServiceImpl.updateById(upautotestapishitu));
  }

  /**
   * 通过id删除autotestapishitu
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/autotestapishitus/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(autotestapishituServiceImpl.removeById(id));
  }

  @PostMapping("/autotestapishitus/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "autotestapishitu");
     params.put("request", condition);

     return XfR.ok(autotestapishituServiceImpl.querys(params));
  }

}
