package com.xforceplus.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Autotestshijianchuo;
import com.xforceplus.jctraincuizheng2.service.IAutotestshijianchuoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * autotestshijianchuo前端控制器
 *
 * @author ultraman
 * @date 2022-01-08
 */
@RestController
public class AutotestshijianchuoController {

  @Autowired
  private IAutotestshijianchuoService autotestshijianchuoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param autotestshijianchuo autotestshijianchuo
   * @return
   */
  @GetMapping("/autotestshijianchuos" )
  public XfR getAutotestshijianchuos(XfPage page, Autotestshijianchuo autotestshijianchuo) {
    return XfR.ok(autotestshijianchuoServiceImpl.page(page, Wrappers.query(autotestshijianchuo)));
  }

  /**
   * 通过id查询autotestshijianchuo
   * @param  id
   * @return XfR
   */
  @GetMapping("/autotestshijianchuos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(autotestshijianchuoServiceImpl.getById(id));
  }

  /**
   * 新增autotestshijianchuo
   * @param autotestshijianchuo autotestshijianchuo
   * @return XfR
   */
  @PostMapping("/autotestshijianchuos")
  public XfR save(@RequestBody Autotestshijianchuo autotestshijianchuo) {
     return XfR.ok(autotestshijianchuoServiceImpl.save(autotestshijianchuo));
  }

  /**
   * 修改-传入修改后的全部数据autotestshijianchuo
   * @param autotestshijianchuo autotestshijianchuo
   * @return XfR
   */
  @PutMapping("/autotestshijianchuos/{id}")
  public XfR putUpdate(@RequestBody Autotestshijianchuo autotestshijianchuo,@PathVariable Long id) {
      autotestshijianchuo.setId(id);
      return XfR.ok(autotestshijianchuoServiceImpl.updateById(autotestshijianchuo));
  }

  /**
   * 修改-传入修改的数据autotestshijianchuo
   * @param autotestshijianchuo autotestshijianchuo
   * @return XfR
   */
  @PatchMapping("/autotestshijianchuos/{id}")
  public XfR patchUpdate(@RequestBody Autotestshijianchuo autotestshijianchuo,@PathVariable Long id) {
      Autotestshijianchuo upautotestshijianchuo = autotestshijianchuoServiceImpl.getById(id);
      if(upautotestshijianchuo != null){
        upautotestshijianchuo = ObjectCopyUtils.copyProperties(autotestshijianchuo,upautotestshijianchuo,true);
      }
      return XfR.ok(autotestshijianchuoServiceImpl.updateById(upautotestshijianchuo));
  }

  /**
   * 通过id删除autotestshijianchuo
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/autotestshijianchuos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(autotestshijianchuoServiceImpl.removeById(id));
  }

  @PostMapping("/autotestshijianchuos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "autotestshijianchuo");
     params.put("request", condition);

     return XfR.ok(autotestshijianchuoServiceImpl.querys(params));
  }

}
