package com.xforceplus.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Autotestfudianxing;
import com.xforceplus.jctraincuizheng2.service.IAutotestfudianxingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * autotestfudianxing前端控制器
 *
 * @author ultraman
 * @date 2022-01-12
 */
@RestController
public class AutotestfudianxingController {

  @Autowired
  private IAutotestfudianxingService autotestfudianxingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param autotestfudianxing autotestfudianxing
   * @return
   */
  @GetMapping("/autotestfudianxings" )
  public XfR getAutotestfudianxings(XfPage page, Autotestfudianxing autotestfudianxing) {
    return XfR.ok(autotestfudianxingServiceImpl.page(page, Wrappers.query(autotestfudianxing)));
  }

  /**
   * 通过id查询autotestfudianxing
   * @param  id
   * @return XfR
   */
  @GetMapping("/autotestfudianxings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(autotestfudianxingServiceImpl.getById(id));
  }

  /**
   * 新增autotestfudianxing
   * @param autotestfudianxing autotestfudianxing
   * @return XfR
   */
  @PostMapping("/autotestfudianxings")
  public XfR save(@RequestBody Autotestfudianxing autotestfudianxing) {
     return XfR.ok(autotestfudianxingServiceImpl.save(autotestfudianxing));
  }

  /**
   * 修改-传入修改后的全部数据autotestfudianxing
   * @param autotestfudianxing autotestfudianxing
   * @return XfR
   */
  @PutMapping("/autotestfudianxings/{id}")
  public XfR putUpdate(@RequestBody Autotestfudianxing autotestfudianxing,@PathVariable Long id) {
      autotestfudianxing.setId(id);
      return XfR.ok(autotestfudianxingServiceImpl.updateById(autotestfudianxing));
  }

  /**
   * 修改-传入修改的数据autotestfudianxing
   * @param autotestfudianxing autotestfudianxing
   * @return XfR
   */
  @PatchMapping("/autotestfudianxings/{id}")
  public XfR patchUpdate(@RequestBody Autotestfudianxing autotestfudianxing,@PathVariable Long id) {
      Autotestfudianxing upautotestfudianxing = autotestfudianxingServiceImpl.getById(id);
      if(upautotestfudianxing != null){
        upautotestfudianxing = ObjectCopyUtils.copyProperties(autotestfudianxing,upautotestfudianxing,true);
      }
      return XfR.ok(autotestfudianxingServiceImpl.updateById(upautotestfudianxing));
  }

  /**
   * 通过id删除autotestfudianxing
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/autotestfudianxings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(autotestfudianxingServiceImpl.removeById(id));
  }

  @PostMapping("/autotestfudianxings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "autotestfudianxing");
     params.put("request", condition);

     return XfR.ok(autotestfudianxingServiceImpl.querys(params));
  }

}
