package com.xforceplus.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Testduozid;
import com.xforceplus.jctraincuizheng2.service.ITestduozidService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * testduozid前端控制器
 *
 * @author ultraman
 * @date 2022-01-12
 */
@RestController
public class TestduozidController {

  @Autowired
  private ITestduozidService testduozidServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testduozid testduozid
   * @return
   */
  @GetMapping("/testduozids" )
  public XfR getTestduozids(XfPage page, Testduozid testduozid) {
    return XfR.ok(testduozidServiceImpl.page(page, Wrappers.query(testduozid)));
  }

  /**
   * 通过id查询testduozid
   * @param  id
   * @return XfR
   */
  @GetMapping("/testduozids/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testduozidServiceImpl.getById(id));
  }

  /**
   * 新增testduozid
   * @param testduozid testduozid
   * @return XfR
   */
  @PostMapping("/testduozids")
  public XfR save(@RequestBody Testduozid testduozid) {
     return XfR.ok(testduozidServiceImpl.save(testduozid));
  }

  /**
   * 修改-传入修改后的全部数据testduozid
   * @param testduozid testduozid
   * @return XfR
   */
  @PutMapping("/testduozids/{id}")
  public XfR putUpdate(@RequestBody Testduozid testduozid,@PathVariable Long id) {
      testduozid.setId(id);
      return XfR.ok(testduozidServiceImpl.updateById(testduozid));
  }

  /**
   * 修改-传入修改的数据testduozid
   * @param testduozid testduozid
   * @return XfR
   */
  @PatchMapping("/testduozids/{id}")
  public XfR patchUpdate(@RequestBody Testduozid testduozid,@PathVariable Long id) {
      Testduozid uptestduozid = testduozidServiceImpl.getById(id);
      if(uptestduozid != null){
        uptestduozid = ObjectCopyUtils.copyProperties(testduozid,uptestduozid,true);
      }
      return XfR.ok(testduozidServiceImpl.updateById(uptestduozid));
  }

  /**
   * 通过id删除testduozid
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testduozids/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testduozidServiceImpl.removeById(id));
  }

  @PostMapping("/testduozids/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testduozid");
     params.put("request", condition);

     return XfR.ok(testduozidServiceImpl.querys(params));
  }

}
