package com.xforceplus.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Autotestbuerzhi;
import com.xforceplus.jctraincuizheng2.service.IAutotestbuerzhiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * autotestbuerzhi前端控制器
 *
 * @author ultraman
 * @date 2022-01-18
 */
@RestController
public class AutotestbuerzhiController {

  @Autowired
  private IAutotestbuerzhiService autotestbuerzhiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param autotestbuerzhi autotestbuerzhi
   * @return
   */
  @GetMapping("/autotestbuerzhis" )
  public XfR getAutotestbuerzhis(XfPage page, Autotestbuerzhi autotestbuerzhi) {
    return XfR.ok(autotestbuerzhiServiceImpl.page(page, Wrappers.query(autotestbuerzhi)));
  }

  /**
   * 通过id查询autotestbuerzhi
   * @param  id
   * @return XfR
   */
  @GetMapping("/autotestbuerzhis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(autotestbuerzhiServiceImpl.getById(id));
  }

  /**
   * 新增autotestbuerzhi
   * @param autotestbuerzhi autotestbuerzhi
   * @return XfR
   */
  @PostMapping("/autotestbuerzhis")
  public XfR save(@RequestBody Autotestbuerzhi autotestbuerzhi) {
     return XfR.ok(autotestbuerzhiServiceImpl.save(autotestbuerzhi));
  }

  /**
   * 修改-传入修改后的全部数据autotestbuerzhi
   * @param autotestbuerzhi autotestbuerzhi
   * @return XfR
   */
  @PutMapping("/autotestbuerzhis/{id}")
  public XfR putUpdate(@RequestBody Autotestbuerzhi autotestbuerzhi,@PathVariable Long id) {
      autotestbuerzhi.setId(id);
      return XfR.ok(autotestbuerzhiServiceImpl.updateById(autotestbuerzhi));
  }

  /**
   * 修改-传入修改的数据autotestbuerzhi
   * @param autotestbuerzhi autotestbuerzhi
   * @return XfR
   */
  @PatchMapping("/autotestbuerzhis/{id}")
  public XfR patchUpdate(@RequestBody Autotestbuerzhi autotestbuerzhi,@PathVariable Long id) {
      Autotestbuerzhi upautotestbuerzhi = autotestbuerzhiServiceImpl.getById(id);
      if(upautotestbuerzhi != null){
        upautotestbuerzhi = ObjectCopyUtils.copyProperties(autotestbuerzhi,upautotestbuerzhi,true);
      }
      return XfR.ok(autotestbuerzhiServiceImpl.updateById(upautotestbuerzhi));
  }

  /**
   * 通过id删除autotestbuerzhi
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/autotestbuerzhis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(autotestbuerzhiServiceImpl.removeById(id));
  }

  @PostMapping("/autotestbuerzhis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "autotestbuerzhi");
     params.put("request", condition);

     return XfR.ok(autotestbuerzhiServiceImpl.querys(params));
  }

}
