package com.xforceplus.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Autotestgongshi;
import com.xforceplus.jctraincuizheng2.service.IAutotestgongshiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * test公式前端控制器
 *
 * @author ultraman
 * @date 2022-01-18
 */
@RestController
public class AutotestgongshiController {

  @Autowired
  private IAutotestgongshiService autotestgongshiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param autotestgongshi test公式
   * @return
   */
  @GetMapping("/autotestgongshis" )
  public XfR getAutotestgongshis(XfPage page, Autotestgongshi autotestgongshi) {
    return XfR.ok(autotestgongshiServiceImpl.page(page, Wrappers.query(autotestgongshi)));
  }

  /**
   * 通过id查询test公式
   * @param  id
   * @return XfR
   */
  @GetMapping("/autotestgongshis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(autotestgongshiServiceImpl.getById(id));
  }

  /**
   * 新增test公式
   * @param autotestgongshi test公式
   * @return XfR
   */
  @PostMapping("/autotestgongshis")
  public XfR save(@RequestBody Autotestgongshi autotestgongshi) {
     return XfR.ok(autotestgongshiServiceImpl.save(autotestgongshi));
  }

  /**
   * 修改-传入修改后的全部数据test公式
   * @param autotestgongshi test公式
   * @return XfR
   */
  @PutMapping("/autotestgongshis/{id}")
  public XfR putUpdate(@RequestBody Autotestgongshi autotestgongshi,@PathVariable Long id) {
      autotestgongshi.setId(id);
      return XfR.ok(autotestgongshiServiceImpl.updateById(autotestgongshi));
  }

  /**
   * 修改-传入修改的数据test公式
   * @param autotestgongshi test公式
   * @return XfR
   */
  @PatchMapping("/autotestgongshis/{id}")
  public XfR patchUpdate(@RequestBody Autotestgongshi autotestgongshi,@PathVariable Long id) {
      Autotestgongshi upautotestgongshi = autotestgongshiServiceImpl.getById(id);
      if(upautotestgongshi != null){
        upautotestgongshi = ObjectCopyUtils.copyProperties(autotestgongshi,upautotestgongshi,true);
      }
      return XfR.ok(autotestgongshiServiceImpl.updateById(upautotestgongshi));
  }

  /**
   * 通过id删除test公式
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/autotestgongshis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(autotestgongshiServiceImpl.removeById(id));
  }

  @PostMapping("/autotestgongshis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "autotestgongshi");
     params.put("request", condition);

     return XfR.ok(autotestgongshiServiceImpl.querys(params));
  }

}
