package com.xforceplus.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Codetest0715;
import com.xforceplus.jctraincuizheng2.service.ICodetest0715Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * codetest0715前端控制器
 *
 * @author ultraman
 * @date 2022-01-18
 */
@RestController
public class Codetest0715Controller {

  @Autowired
  private ICodetest0715Service codetest0715ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param codetest0715 codetest0715
   * @return
   */
  @GetMapping("/codetest0715s" )
  public XfR getCodetest0715s(XfPage page, Codetest0715 codetest0715) {
    return XfR.ok(codetest0715ServiceImpl.page(page, Wrappers.query(codetest0715)));
  }

  /**
   * 通过id查询codetest0715
   * @param  id
   * @return XfR
   */
  @GetMapping("/codetest0715s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(codetest0715ServiceImpl.getById(id));
  }

  /**
   * 新增codetest0715
   * @param codetest0715 codetest0715
   * @return XfR
   */
  @PostMapping("/codetest0715s")
  public XfR save(@RequestBody Codetest0715 codetest0715) {
     return XfR.ok(codetest0715ServiceImpl.save(codetest0715));
  }

  /**
   * 修改-传入修改后的全部数据codetest0715
   * @param codetest0715 codetest0715
   * @return XfR
   */
  @PutMapping("/codetest0715s/{id}")
  public XfR putUpdate(@RequestBody Codetest0715 codetest0715,@PathVariable Long id) {
      codetest0715.setId(id);
      return XfR.ok(codetest0715ServiceImpl.updateById(codetest0715));
  }

  /**
   * 修改-传入修改的数据codetest0715
   * @param codetest0715 codetest0715
   * @return XfR
   */
  @PatchMapping("/codetest0715s/{id}")
  public XfR patchUpdate(@RequestBody Codetest0715 codetest0715,@PathVariable Long id) {
      Codetest0715 upcodetest0715 = codetest0715ServiceImpl.getById(id);
      if(upcodetest0715 != null){
        upcodetest0715 = ObjectCopyUtils.copyProperties(codetest0715,upcodetest0715,true);
      }
      return XfR.ok(codetest0715ServiceImpl.updateById(upcodetest0715));
  }

  /**
   * 通过id删除codetest0715
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/codetest0715s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(codetest0715ServiceImpl.removeById(id));
  }

  @PostMapping("/codetest0715s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "codetest0715");
     params.put("request", condition);

     return XfR.ok(codetest0715ServiceImpl.querys(params));
  }

}
