package com.xforceplus.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Autotestduozhimjx;
import com.xforceplus.jctraincuizheng2.service.IAutotestduozhimjxService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 多值枚举型前端控制器
 *
 * @author ultraman
 * @date 2022-01-25
 */
@RestController
public class AutotestduozhimjxController {

  @Autowired
  private IAutotestduozhimjxService autotestduozhimjxServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param autotestduozhimjx 多值枚举型
   * @return
   */
  @GetMapping("/autotestduozhimjxs" )
  public XfR getAutotestduozhimjxs(XfPage page, Autotestduozhimjx autotestduozhimjx) {
    return XfR.ok(autotestduozhimjxServiceImpl.page(page, Wrappers.query(autotestduozhimjx)));
  }

  /**
   * 通过id查询多值枚举型
   * @param  id
   * @return XfR
   */
  @GetMapping("/autotestduozhimjxs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(autotestduozhimjxServiceImpl.getById(id));
  }

  /**
   * 新增多值枚举型
   * @param autotestduozhimjx 多值枚举型
   * @return XfR
   */
  @PostMapping("/autotestduozhimjxs")
  public XfR save(@RequestBody Autotestduozhimjx autotestduozhimjx) {
     return XfR.ok(autotestduozhimjxServiceImpl.save(autotestduozhimjx));
  }

  /**
   * 修改-传入修改后的全部数据多值枚举型
   * @param autotestduozhimjx 多值枚举型
   * @return XfR
   */
  @PutMapping("/autotestduozhimjxs/{id}")
  public XfR putUpdate(@RequestBody Autotestduozhimjx autotestduozhimjx,@PathVariable Long id) {
      autotestduozhimjx.setId(id);
      return XfR.ok(autotestduozhimjxServiceImpl.updateById(autotestduozhimjx));
  }

  /**
   * 修改-传入修改的数据多值枚举型
   * @param autotestduozhimjx 多值枚举型
   * @return XfR
   */
  @PatchMapping("/autotestduozhimjxs/{id}")
  public XfR patchUpdate(@RequestBody Autotestduozhimjx autotestduozhimjx,@PathVariable Long id) {
      Autotestduozhimjx upautotestduozhimjx = autotestduozhimjxServiceImpl.getById(id);
      if(upautotestduozhimjx != null){
        upautotestduozhimjx = ObjectCopyUtils.copyProperties(autotestduozhimjx,upautotestduozhimjx,true);
      }
      return XfR.ok(autotestduozhimjxServiceImpl.updateById(upautotestduozhimjx));
  }

  /**
   * 通过id删除多值枚举型
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/autotestduozhimjxs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(autotestduozhimjxServiceImpl.removeById(id));
  }

  @PostMapping("/autotestduozhimjxs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "autotestduozhimjx");
     params.put("request", condition);

     return XfR.ok(autotestduozhimjxServiceImpl.querys(params));
  }

}
