package com.xforceplus.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Privacy;
import com.xforceplus.jctraincuizheng2.service.IPrivacyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-01-25
 */
@RestController
public class PrivacyController {

  @Autowired
  private IPrivacyService privacyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param privacy ${table.comment}
   * @return
   */
  @GetMapping("/privacys" )
  public XfR getPrivacys(XfPage page, Privacy privacy) {
    return XfR.ok(privacyServiceImpl.page(page, Wrappers.query(privacy)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/privacys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(privacyServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param privacy ${table.comment}
   * @return XfR
   */
  @PostMapping("/privacys")
  public XfR save(@RequestBody Privacy privacy) {
     return XfR.ok(privacyServiceImpl.save(privacy));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param privacy ${table.comment}
   * @return XfR
   */
  @PutMapping("/privacys/{id}")
  public XfR putUpdate(@RequestBody Privacy privacy,@PathVariable Long id) {
      privacy.setId(id);
      return XfR.ok(privacyServiceImpl.updateById(privacy));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param privacy ${table.comment}
   * @return XfR
   */
  @PatchMapping("/privacys/{id}")
  public XfR patchUpdate(@RequestBody Privacy privacy,@PathVariable Long id) {
      Privacy upprivacy = privacyServiceImpl.getById(id);
      if(upprivacy != null){
        upprivacy = ObjectCopyUtils.copyProperties(privacy,upprivacy,true);
      }
      return XfR.ok(privacyServiceImpl.updateById(upprivacy));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/privacys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(privacyServiceImpl.removeById(id));
  }

  @PostMapping("/privacys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "privacy");
     params.put("request", condition);

     return XfR.ok(privacyServiceImpl.querys(params));
  }

}
