package com.xforceplus.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Apitestobject25;
import com.xforceplus.jctraincuizheng2.service.IApitestobject25Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * apitestobject25前端控制器
 *
 * @author ultraman
 * @date 2022-02-23
 */
@RestController
public class Apitestobject25Controller {

  @Autowired
  private IApitestobject25Service apitestobject25ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param apitestobject25 apitestobject25
   * @return
   */
  @GetMapping("/apitestobject25s" )
  public XfR getApitestobject25s(XfPage page, Apitestobject25 apitestobject25) {
    return XfR.ok(apitestobject25ServiceImpl.page(page, Wrappers.query(apitestobject25)));
  }

  /**
   * 通过id查询apitestobject25
   * @param  id
   * @return XfR
   */
  @GetMapping("/apitestobject25s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(apitestobject25ServiceImpl.getById(id));
  }

  /**
   * 新增apitestobject25
   * @param apitestobject25 apitestobject25
   * @return XfR
   */
  @PostMapping("/apitestobject25s")
  public XfR save(@RequestBody Apitestobject25 apitestobject25) {
     return XfR.ok(apitestobject25ServiceImpl.save(apitestobject25));
  }

  /**
   * 修改-传入修改后的全部数据apitestobject25
   * @param apitestobject25 apitestobject25
   * @return XfR
   */
  @PutMapping("/apitestobject25s/{id}")
  public XfR putUpdate(@RequestBody Apitestobject25 apitestobject25,@PathVariable Long id) {
      apitestobject25.setId(id);
      return XfR.ok(apitestobject25ServiceImpl.updateById(apitestobject25));
  }

  /**
   * 修改-传入修改的数据apitestobject25
   * @param apitestobject25 apitestobject25
   * @return XfR
   */
  @PatchMapping("/apitestobject25s/{id}")
  public XfR patchUpdate(@RequestBody Apitestobject25 apitestobject25,@PathVariable Long id) {
      Apitestobject25 upapitestobject25 = apitestobject25ServiceImpl.getById(id);
      if(upapitestobject25 != null){
        upapitestobject25 = ObjectCopyUtils.copyProperties(apitestobject25,upapitestobject25,true);
      }
      return XfR.ok(apitestobject25ServiceImpl.updateById(upapitestobject25));
  }

  /**
   * 通过id删除apitestobject25
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/apitestobject25s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(apitestobject25ServiceImpl.removeById(id));
  }

  @PostMapping("/apitestobject25s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "apitestobject25");
     params.put("request", condition);

     return XfR.ok(apitestobject25ServiceImpl.querys(params));
  }

}
