package com.xforceplus.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Beilookup;
import com.xforceplus.jctraincuizheng2.service.IBeilookupService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * beilookup1229前端控制器
 *
 * @author ultraman
 * @date 2022-02-23
 */
@RestController
public class BeilookupController {

  @Autowired
  private IBeilookupService beilookupServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param beilookup beilookup1229
   * @return
   */
  @GetMapping("/beilookups" )
  public XfR getBeilookups(XfPage page, Beilookup beilookup) {
    return XfR.ok(beilookupServiceImpl.page(page, Wrappers.query(beilookup)));
  }

  /**
   * 通过id查询beilookup1229
   * @param  id
   * @return XfR
   */
  @GetMapping("/beilookups/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(beilookupServiceImpl.getById(id));
  }

  /**
   * 新增beilookup1229
   * @param beilookup beilookup1229
   * @return XfR
   */
  @PostMapping("/beilookups")
  public XfR save(@RequestBody Beilookup beilookup) {
     return XfR.ok(beilookupServiceImpl.save(beilookup));
  }

  /**
   * 修改-传入修改后的全部数据beilookup1229
   * @param beilookup beilookup1229
   * @return XfR
   */
  @PutMapping("/beilookups/{id}")
  public XfR putUpdate(@RequestBody Beilookup beilookup,@PathVariable Long id) {
      beilookup.setId(id);
      return XfR.ok(beilookupServiceImpl.updateById(beilookup));
  }

  /**
   * 修改-传入修改的数据beilookup1229
   * @param beilookup beilookup1229
   * @return XfR
   */
  @PatchMapping("/beilookups/{id}")
  public XfR patchUpdate(@RequestBody Beilookup beilookup,@PathVariable Long id) {
      Beilookup upbeilookup = beilookupServiceImpl.getById(id);
      if(upbeilookup != null){
        upbeilookup = ObjectCopyUtils.copyProperties(beilookup,upbeilookup,true);
      }
      return XfR.ok(beilookupServiceImpl.updateById(upbeilookup));
  }

  /**
   * 通过id删除beilookup1229
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/beilookups/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(beilookupServiceImpl.removeById(id));
  }

  @PostMapping("/beilookups/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "beilookup");
     params.put("request", condition);

     return XfR.ok(beilookupServiceImpl.querys(params));
  }

}
