package com.xforceplus.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Codebanji;
import com.xforceplus.jctraincuizheng2.service.ICodebanjiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 测试导入支持一对多前端控制器
 *
 * @author ultraman
 * @date 2022-02-23
 */
@RestController
public class CodebanjiController {

  @Autowired
  private ICodebanjiService codebanjiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param codebanji 测试导入支持一对多
   * @return
   */
  @GetMapping("/codebanjis" )
  public XfR getCodebanjis(XfPage page, Codebanji codebanji) {
    return XfR.ok(codebanjiServiceImpl.page(page, Wrappers.query(codebanji)));
  }

  /**
   * 通过id查询测试导入支持一对多
   * @param  id
   * @return XfR
   */
  @GetMapping("/codebanjis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(codebanjiServiceImpl.getById(id));
  }

  /**
   * 新增测试导入支持一对多
   * @param codebanji 测试导入支持一对多
   * @return XfR
   */
  @PostMapping("/codebanjis")
  public XfR save(@RequestBody Codebanji codebanji) {
     return XfR.ok(codebanjiServiceImpl.save(codebanji));
  }

  /**
   * 修改-传入修改后的全部数据测试导入支持一对多
   * @param codebanji 测试导入支持一对多
   * @return XfR
   */
  @PutMapping("/codebanjis/{id}")
  public XfR putUpdate(@RequestBody Codebanji codebanji,@PathVariable Long id) {
      codebanji.setId(id);
      return XfR.ok(codebanjiServiceImpl.updateById(codebanji));
  }

  /**
   * 修改-传入修改的数据测试导入支持一对多
   * @param codebanji 测试导入支持一对多
   * @return XfR
   */
  @PatchMapping("/codebanjis/{id}")
  public XfR patchUpdate(@RequestBody Codebanji codebanji,@PathVariable Long id) {
      Codebanji upcodebanji = codebanjiServiceImpl.getById(id);
      if(upcodebanji != null){
        upcodebanji = ObjectCopyUtils.copyProperties(codebanji,upcodebanji,true);
      }
      return XfR.ok(codebanjiServiceImpl.updateById(upcodebanji));
  }

  /**
   * 通过id删除测试导入支持一对多
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/codebanjis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(codebanjiServiceImpl.removeById(id));
  }

  @PostMapping("/codebanjis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "codebanji");
     params.put("request", condition);

     return XfR.ok(codebanjiServiceImpl.querys(params));
  }

}
