package com.xforceplus.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Codenianji;
import com.xforceplus.jctraincuizheng2.service.ICodenianjiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 测试导入支持一对多前端控制器
 *
 * @author ultraman
 * @date 2022-02-23
 */
@RestController
public class CodenianjiController {

  @Autowired
  private ICodenianjiService codenianjiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param codenianji 测试导入支持一对多
   * @return
   */
  @GetMapping("/codenianjis" )
  public XfR getCodenianjis(XfPage page, Codenianji codenianji) {
    return XfR.ok(codenianjiServiceImpl.page(page, Wrappers.query(codenianji)));
  }

  /**
   * 通过id查询测试导入支持一对多
   * @param  id
   * @return XfR
   */
  @GetMapping("/codenianjis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(codenianjiServiceImpl.getById(id));
  }

  /**
   * 新增测试导入支持一对多
   * @param codenianji 测试导入支持一对多
   * @return XfR
   */
  @PostMapping("/codenianjis")
  public XfR save(@RequestBody Codenianji codenianji) {
     return XfR.ok(codenianjiServiceImpl.save(codenianji));
  }

  /**
   * 修改-传入修改后的全部数据测试导入支持一对多
   * @param codenianji 测试导入支持一对多
   * @return XfR
   */
  @PutMapping("/codenianjis/{id}")
  public XfR putUpdate(@RequestBody Codenianji codenianji,@PathVariable Long id) {
      codenianji.setId(id);
      return XfR.ok(codenianjiServiceImpl.updateById(codenianji));
  }

  /**
   * 修改-传入修改的数据测试导入支持一对多
   * @param codenianji 测试导入支持一对多
   * @return XfR
   */
  @PatchMapping("/codenianjis/{id}")
  public XfR patchUpdate(@RequestBody Codenianji codenianji,@PathVariable Long id) {
      Codenianji upcodenianji = codenianjiServiceImpl.getById(id);
      if(upcodenianji != null){
        upcodenianji = ObjectCopyUtils.copyProperties(codenianji,upcodenianji,true);
      }
      return XfR.ok(codenianjiServiceImpl.updateById(upcodenianji));
  }

  /**
   * 通过id删除测试导入支持一对多
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/codenianjis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(codenianjiServiceImpl.removeById(id));
  }

  @PostMapping("/codenianjis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "codenianji");
     params.put("request", condition);

     return XfR.ok(codenianjiServiceImpl.querys(params));
  }

}
