package com.xforceplus.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Paix;
import com.xforceplus.jctraincuizheng2.service.IPaixService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 排序前端控制器
 *
 * @author ultraman
 * @date 2022-02-23
 */
@RestController
public class PaixController {

  @Autowired
  private IPaixService paixServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param paix 排序
   * @return
   */
  @GetMapping("/paixs" )
  public XfR getPaixs(XfPage page, Paix paix) {
    return XfR.ok(paixServiceImpl.page(page, Wrappers.query(paix)));
  }

  /**
   * 通过id查询排序
   * @param  id
   * @return XfR
   */
  @GetMapping("/paixs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(paixServiceImpl.getById(id));
  }

  /**
   * 新增排序
   * @param paix 排序
   * @return XfR
   */
  @PostMapping("/paixs")
  public XfR save(@RequestBody Paix paix) {
     return XfR.ok(paixServiceImpl.save(paix));
  }

  /**
   * 修改-传入修改后的全部数据排序
   * @param paix 排序
   * @return XfR
   */
  @PutMapping("/paixs/{id}")
  public XfR putUpdate(@RequestBody Paix paix,@PathVariable Long id) {
      paix.setId(id);
      return XfR.ok(paixServiceImpl.updateById(paix));
  }

  /**
   * 修改-传入修改的数据排序
   * @param paix 排序
   * @return XfR
   */
  @PatchMapping("/paixs/{id}")
  public XfR patchUpdate(@RequestBody Paix paix,@PathVariable Long id) {
      Paix uppaix = paixServiceImpl.getById(id);
      if(uppaix != null){
        uppaix = ObjectCopyUtils.copyProperties(paix,uppaix,true);
      }
      return XfR.ok(paixServiceImpl.updateById(uppaix));
  }

  /**
   * 通过id删除排序
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/paixs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(paixServiceImpl.removeById(id));
  }

  @PostMapping("/paixs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "paix");
     params.put("request", condition);

     return XfR.ok(paixServiceImpl.querys(params));
  }

}
