package com.xforceplus.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Test0217001;
import com.xforceplus.jctraincuizheng2.service.ITest0217001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * test0217001前端控制器
 *
 * @author ultraman
 * @date 2022-02-23
 */
@RestController
public class Test0217001Controller {

  @Autowired
  private ITest0217001Service test0217001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test0217001 test0217001
   * @return
   */
  @GetMapping("/test0217001s" )
  public XfR getTest0217001s(XfPage page, Test0217001 test0217001) {
    return XfR.ok(test0217001ServiceImpl.page(page, Wrappers.query(test0217001)));
  }

  /**
   * 通过id查询test0217001
   * @param  id
   * @return XfR
   */
  @GetMapping("/test0217001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test0217001ServiceImpl.getById(id));
  }

  /**
   * 新增test0217001
   * @param test0217001 test0217001
   * @return XfR
   */
  @PostMapping("/test0217001s")
  public XfR save(@RequestBody Test0217001 test0217001) {
     return XfR.ok(test0217001ServiceImpl.save(test0217001));
  }

  /**
   * 修改-传入修改后的全部数据test0217001
   * @param test0217001 test0217001
   * @return XfR
   */
  @PutMapping("/test0217001s/{id}")
  public XfR putUpdate(@RequestBody Test0217001 test0217001,@PathVariable Long id) {
      test0217001.setId(id);
      return XfR.ok(test0217001ServiceImpl.updateById(test0217001));
  }

  /**
   * 修改-传入修改的数据test0217001
   * @param test0217001 test0217001
   * @return XfR
   */
  @PatchMapping("/test0217001s/{id}")
  public XfR patchUpdate(@RequestBody Test0217001 test0217001,@PathVariable Long id) {
      Test0217001 uptest0217001 = test0217001ServiceImpl.getById(id);
      if(uptest0217001 != null){
        uptest0217001 = ObjectCopyUtils.copyProperties(test0217001,uptest0217001,true);
      }
      return XfR.ok(test0217001ServiceImpl.updateById(uptest0217001));
  }

  /**
   * 通过id删除test0217001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test0217001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test0217001ServiceImpl.removeById(id));
  }

  @PostMapping("/test0217001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test0217001");
     params.put("request", condition);

     return XfR.ok(test0217001ServiceImpl.querys(params));
  }

}
