package com.xforceplus.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Test0217;
import com.xforceplus.jctraincuizheng2.service.ITest0217Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 从资产中心下载前端控制器
 *
 * @author ultraman
 * @date 2022-02-23
 */
@RestController
public class Test0217Controller {

  @Autowired
  private ITest0217Service test0217ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test0217 从资产中心下载
   * @return
   */
  @GetMapping("/test0217s" )
  public XfR getTest0217s(XfPage page, Test0217 test0217) {
    return XfR.ok(test0217ServiceImpl.page(page, Wrappers.query(test0217)));
  }

  /**
   * 通过id查询从资产中心下载
   * @param  id
   * @return XfR
   */
  @GetMapping("/test0217s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test0217ServiceImpl.getById(id));
  }

  /**
   * 新增从资产中心下载
   * @param test0217 从资产中心下载
   * @return XfR
   */
  @PostMapping("/test0217s")
  public XfR save(@RequestBody Test0217 test0217) {
     return XfR.ok(test0217ServiceImpl.save(test0217));
  }

  /**
   * 修改-传入修改后的全部数据从资产中心下载
   * @param test0217 从资产中心下载
   * @return XfR
   */
  @PutMapping("/test0217s/{id}")
  public XfR putUpdate(@RequestBody Test0217 test0217,@PathVariable Long id) {
      test0217.setId(id);
      return XfR.ok(test0217ServiceImpl.updateById(test0217));
  }

  /**
   * 修改-传入修改的数据从资产中心下载
   * @param test0217 从资产中心下载
   * @return XfR
   */
  @PatchMapping("/test0217s/{id}")
  public XfR patchUpdate(@RequestBody Test0217 test0217,@PathVariable Long id) {
      Test0217 uptest0217 = test0217ServiceImpl.getById(id);
      if(uptest0217 != null){
        uptest0217 = ObjectCopyUtils.copyProperties(test0217,uptest0217,true);
      }
      return XfR.ok(test0217ServiceImpl.updateById(uptest0217));
  }

  /**
   * 通过id删除从资产中心下载
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test0217s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test0217ServiceImpl.removeById(id));
  }

  @PostMapping("/test0217s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test0217");
     params.put("request", condition);

     return XfR.ok(test0217ServiceImpl.querys(params));
  }

}
