package com.xforceplus.jctraincuizheng2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctraincuizheng2.entity.Test1228;
import com.xforceplus.jctraincuizheng2.service.ITest1228Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * test1228前端控制器
 *
 * @author ultraman
 * @date 2022-02-23
 */
@RestController
public class Test1228Controller {

  @Autowired
  private ITest1228Service test1228ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test1228 test1228
   * @return
   */
  @GetMapping("/test1228s" )
  public XfR getTest1228s(XfPage page, Test1228 test1228) {
    return XfR.ok(test1228ServiceImpl.page(page, Wrappers.query(test1228)));
  }

  /**
   * 通过id查询test1228
   * @param  id
   * @return XfR
   */
  @GetMapping("/test1228s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test1228ServiceImpl.getById(id));
  }

  /**
   * 新增test1228
   * @param test1228 test1228
   * @return XfR
   */
  @PostMapping("/test1228s")
  public XfR save(@RequestBody Test1228 test1228) {
     return XfR.ok(test1228ServiceImpl.save(test1228));
  }

  /**
   * 修改-传入修改后的全部数据test1228
   * @param test1228 test1228
   * @return XfR
   */
  @PutMapping("/test1228s/{id}")
  public XfR putUpdate(@RequestBody Test1228 test1228,@PathVariable Long id) {
      test1228.setId(id);
      return XfR.ok(test1228ServiceImpl.updateById(test1228));
  }

  /**
   * 修改-传入修改的数据test1228
   * @param test1228 test1228
   * @return XfR
   */
  @PatchMapping("/test1228s/{id}")
  public XfR patchUpdate(@RequestBody Test1228 test1228,@PathVariable Long id) {
      Test1228 uptest1228 = test1228ServiceImpl.getById(id);
      if(uptest1228 != null){
        uptest1228 = ObjectCopyUtils.copyProperties(test1228,uptest1228,true);
      }
      return XfR.ok(test1228ServiceImpl.updateById(uptest1228));
  }

  /**
   * 通过id删除test1228
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test1228s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test1228ServiceImpl.removeById(id));
  }

  @PostMapping("/test1228s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test1228");
     params.put("request", condition);

     return XfR.ok(test1228ServiceImpl.querys(params));
  }

}
