package com.xforceplus.jctrainnanguiqiong.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 票据类型
 * </p>
 *
 * @author ultraman
 * @since 2021-07-10
 */
public enum InvoiceType {

    S("s", "增值税电子专票发票"),
    E("e", "增值税普通发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "e":
                return E;
            default:
                return null;
        }
    }
}
