package com.xforceplus.jcultramanlaiwenlu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcultramanlaiwenlu.entity.BizOrderItemlaiwenlu;
import com.xforceplus.jcultramanlaiwenlu.service.IBizOrderItemlaiwenluService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 业务单明细对象前端控制器
 *
 * @author ultraman
 * @date 2024-03-28
 */
@RestController
public class BizOrderItemlaiwenluController {

  @Autowired
  private IBizOrderItemlaiwenluService bizOrderItemlaiwenluServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizOrderItemlaiwenlu 业务单明细对象
   * @return
   */
  @GetMapping("/bizorderitemlaiwenlus" )
  public XfR getBizOrderItemlaiwenlus(XfPage page, BizOrderItemlaiwenlu bizOrderItemlaiwenlu) {
    return XfR.ok(bizOrderItemlaiwenluServiceImpl.page(page, Wrappers.query(bizOrderItemlaiwenlu)));
  }

  /**
   * 通过id查询业务单明细对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizorderitemlaiwenlus/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizOrderItemlaiwenluServiceImpl.getById(id));
  }

  /**
   * 新增业务单明细对象
   * @param bizOrderItemlaiwenlu 业务单明细对象
   * @return XfR
   */
  @PostMapping("/bizorderitemlaiwenlus")
  public XfR save(@RequestBody BizOrderItemlaiwenlu bizOrderItemlaiwenlu) {
     return XfR.ok(bizOrderItemlaiwenluServiceImpl.save(bizOrderItemlaiwenlu));
  }

  /**
   * 修改-传入修改后的全部数据业务单明细对象
   * @param bizOrderItemlaiwenlu 业务单明细对象
   * @return XfR
   */
  @PutMapping("/bizorderitemlaiwenlus/{id}")
  public XfR putUpdate(@RequestBody BizOrderItemlaiwenlu bizOrderItemlaiwenlu,@PathVariable Long id) {
      bizOrderItemlaiwenlu.setId(id);
      return XfR.ok(bizOrderItemlaiwenluServiceImpl.updateById(bizOrderItemlaiwenlu));
  }

  /**
   * 修改-传入修改的数据业务单明细对象
   * @param bizOrderItemlaiwenlu 业务单明细对象
   * @return XfR
   */
  @PatchMapping("/bizorderitemlaiwenlus/{id}")
  public XfR patchUpdate(@RequestBody BizOrderItemlaiwenlu bizOrderItemlaiwenlu,@PathVariable Long id) {
      BizOrderItemlaiwenlu upbizOrderItemlaiwenlu = bizOrderItemlaiwenluServiceImpl.getById(id);
      if(upbizOrderItemlaiwenlu != null){
        upbizOrderItemlaiwenlu = ObjectCopyUtils.copyProperties(bizOrderItemlaiwenlu,upbizOrderItemlaiwenlu,true);
      }
      return XfR.ok(bizOrderItemlaiwenluServiceImpl.updateById(upbizOrderItemlaiwenlu));
  }

  /**
   * 通过id删除业务单明细对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizorderitemlaiwenlus/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizOrderItemlaiwenluServiceImpl.removeById(id));
  }

  @PostMapping("/bizorderitemlaiwenlus/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_order_itemlaiwenlu");
     params.put("request", condition);

     return XfR.ok(bizOrderItemlaiwenluServiceImpl.querys(params));
  }

}
