package com.xforceplus.jcultramanlaiwenlu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcultramanlaiwenlu.entity.BizOrderlaiwenlu;
import com.xforceplus.jcultramanlaiwenlu.service.IBizOrderlaiwenluService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 业务单主对象前端控制器
 *
 * @author ultraman
 * @date 2024-03-28
 */
@RestController
public class BizOrderlaiwenluController {

  @Autowired
  private IBizOrderlaiwenluService bizOrderlaiwenluServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizOrderlaiwenlu 业务单主对象
   * @return
   */
  @GetMapping("/bizorderlaiwenlus" )
  public XfR getBizOrderlaiwenlus(XfPage page, BizOrderlaiwenlu bizOrderlaiwenlu) {
    return XfR.ok(bizOrderlaiwenluServiceImpl.page(page, Wrappers.query(bizOrderlaiwenlu)));
  }

  /**
   * 通过id查询业务单主对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizorderlaiwenlus/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizOrderlaiwenluServiceImpl.getById(id));
  }

  /**
   * 新增业务单主对象
   * @param bizOrderlaiwenlu 业务单主对象
   * @return XfR
   */
  @PostMapping("/bizorderlaiwenlus")
  public XfR save(@RequestBody BizOrderlaiwenlu bizOrderlaiwenlu) {
     return XfR.ok(bizOrderlaiwenluServiceImpl.save(bizOrderlaiwenlu));
  }

  /**
   * 修改-传入修改后的全部数据业务单主对象
   * @param bizOrderlaiwenlu 业务单主对象
   * @return XfR
   */
  @PutMapping("/bizorderlaiwenlus/{id}")
  public XfR putUpdate(@RequestBody BizOrderlaiwenlu bizOrderlaiwenlu,@PathVariable Long id) {
      bizOrderlaiwenlu.setId(id);
      return XfR.ok(bizOrderlaiwenluServiceImpl.updateById(bizOrderlaiwenlu));
  }

  /**
   * 修改-传入修改的数据业务单主对象
   * @param bizOrderlaiwenlu 业务单主对象
   * @return XfR
   */
  @PatchMapping("/bizorderlaiwenlus/{id}")
  public XfR patchUpdate(@RequestBody BizOrderlaiwenlu bizOrderlaiwenlu,@PathVariable Long id) {
      BizOrderlaiwenlu upbizOrderlaiwenlu = bizOrderlaiwenluServiceImpl.getById(id);
      if(upbizOrderlaiwenlu != null){
        upbizOrderlaiwenlu = ObjectCopyUtils.copyProperties(bizOrderlaiwenlu,upbizOrderlaiwenlu,true);
      }
      return XfR.ok(bizOrderlaiwenluServiceImpl.updateById(upbizOrderlaiwenlu));
  }

  /**
   * 通过id删除业务单主对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizorderlaiwenlus/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizOrderlaiwenluServiceImpl.removeById(id));
  }

  @PostMapping("/bizorderlaiwenlus/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_orderlaiwenlu");
     params.put("request", condition);

     return XfR.ok(bizOrderlaiwenluServiceImpl.querys(params));
  }

}
