package com.xforceplus.jcultramanlaiwenlu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcultramanlaiwenlu.entity.SellerInvoiceDetailslaiwenlu;
import com.xforceplus.jcultramanlaiwenlu.service.ISellerInvoiceDetailslaiwenluService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-03-28
 */
@RestController
public class SellerInvoiceDetailslaiwenluController {

  @Autowired
  private ISellerInvoiceDetailslaiwenluService sellerInvoiceDetailslaiwenluServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sellerInvoiceDetailslaiwenlu ${table.comment}
   * @return
   */
  @GetMapping("/sellerinvoicedetailslaiwenlus" )
  public XfR getSellerInvoiceDetailslaiwenlus(XfPage page, SellerInvoiceDetailslaiwenlu sellerInvoiceDetailslaiwenlu) {
    return XfR.ok(sellerInvoiceDetailslaiwenluServiceImpl.page(page, Wrappers.query(sellerInvoiceDetailslaiwenlu)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/sellerinvoicedetailslaiwenlus/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sellerInvoiceDetailslaiwenluServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param sellerInvoiceDetailslaiwenlu ${table.comment}
   * @return XfR
   */
  @PostMapping("/sellerinvoicedetailslaiwenlus")
  public XfR save(@RequestBody SellerInvoiceDetailslaiwenlu sellerInvoiceDetailslaiwenlu) {
     return XfR.ok(sellerInvoiceDetailslaiwenluServiceImpl.save(sellerInvoiceDetailslaiwenlu));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param sellerInvoiceDetailslaiwenlu ${table.comment}
   * @return XfR
   */
  @PutMapping("/sellerinvoicedetailslaiwenlus/{id}")
  public XfR putUpdate(@RequestBody SellerInvoiceDetailslaiwenlu sellerInvoiceDetailslaiwenlu,@PathVariable Long id) {
      sellerInvoiceDetailslaiwenlu.setId(id);
      return XfR.ok(sellerInvoiceDetailslaiwenluServiceImpl.updateById(sellerInvoiceDetailslaiwenlu));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param sellerInvoiceDetailslaiwenlu ${table.comment}
   * @return XfR
   */
  @PatchMapping("/sellerinvoicedetailslaiwenlus/{id}")
  public XfR patchUpdate(@RequestBody SellerInvoiceDetailslaiwenlu sellerInvoiceDetailslaiwenlu,@PathVariable Long id) {
      SellerInvoiceDetailslaiwenlu upsellerInvoiceDetailslaiwenlu = sellerInvoiceDetailslaiwenluServiceImpl.getById(id);
      if(upsellerInvoiceDetailslaiwenlu != null){
        upsellerInvoiceDetailslaiwenlu = ObjectCopyUtils.copyProperties(sellerInvoiceDetailslaiwenlu,upsellerInvoiceDetailslaiwenlu,true);
      }
      return XfR.ok(sellerInvoiceDetailslaiwenluServiceImpl.updateById(upsellerInvoiceDetailslaiwenlu));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sellerinvoicedetailslaiwenlus/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sellerInvoiceDetailslaiwenluServiceImpl.removeById(id));
  }

  @PostMapping("/sellerinvoicedetailslaiwenlus/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "seller_invoice_detailslaiwenlu");
     params.put("request", condition);

     return XfR.ok(sellerInvoiceDetailslaiwenluServiceImpl.querys(params));
  }

}
