package com.xforceplus.jcultramanljj.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2025-01-15
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcultramanljj.entity.Zhineng;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-ultraman-ljj")
public interface ZhinengFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/zhineng/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param zhineng ${table.comment}
   * @return R
   */
  @PostMapping("/zhineng/add")
  public R save(@RequestBody Zhineng zhineng);

  /**
   * 修改${table.comment}
   * @param zhineng ${table.comment}
   * @return R
   */
  @PostMapping("/zhineng/update")
  public R updateById(@RequestBody Zhineng zhineng);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/zhineng/del/{id}" )
  public R removeById(@PathVariable Long id);

}