package com.xforceplus.jcultramanocrdemo.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-08-19
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcultramanocrdemo.entity.AnalyzingRule;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-ultraman-ocrdemo")
public interface AnalyzingRuleFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/analyzingRule/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param analyzingRule ${table.comment}
   * @return R
   */
  @PostMapping("/analyzingRule/add")
  public R save(@RequestBody AnalyzingRule analyzingRule);

  /**
   * 修改${table.comment}
   * @param analyzingRule ${table.comment}
   * @return R
   */
  @PostMapping("/analyzingRule/update")
  public R updateById(@RequestBody AnalyzingRule analyzingRule);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/analyzingRule/del/{id}" )
  public R removeById(@PathVariable Long id);

}