/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jcultramanocrdemo.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.jcultramanocrdemo.entity.Model;
import com.xforceplus.jcultramanocrdemo.service.IModelService;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ModelController {
    @Autowired
    private IModelService modelServiceImpl;

    @GetMapping(value={"/models"})
    public XfR getModels(XfPage page, Model model) {
        return XfR.ok((Object)this.modelServiceImpl.page((IPage)page, (Wrapper)Wrappers.query((Object)model)));
    }

    @GetMapping(value={"/models/{id}"})
    public XfR getById(@PathVariable Long id) {
        return XfR.ok((Object)this.modelServiceImpl.getById(id));
    }

    @PostMapping(value={"/models"})
    public XfR save(@RequestBody Model model) {
        return XfR.ok((Object)this.modelServiceImpl.save(model));
    }

    @PutMapping(value={"/models/{id}"})
    public XfR putUpdate(@RequestBody Model model, @PathVariable Long id) {
        model.setId(id);
        return XfR.ok((Object)this.modelServiceImpl.updateById(model));
    }

    @PatchMapping(value={"/models/{id}"})
    public XfR patchUpdate(@RequestBody Model model, @PathVariable Long id) {
        Model upmodel = (Model)this.modelServiceImpl.getById(id);
        if (upmodel != null) {
            upmodel = (Model)ObjectCopyUtils.copyProperties((Object)model, (Object)upmodel, (boolean)true);
        }
        return XfR.ok((Object)this.modelServiceImpl.updateById(upmodel));
    }

    @DeleteMapping(value={"/models/{id}"})
    public XfR removeById(@PathVariable Long id) {
        return XfR.ok((Object)this.modelServiceImpl.removeById(id));
    }

    @PostMapping(value={"/models/query"})
    public XfR querys(@RequestBody ConditionQueryRequest condition) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tableName", "model");
        params.put("request", condition);
        return XfR.ok(this.modelServiceImpl.querys(params));
    }
}

