package com.xforceplus.jcultramantongjunxian.controller;


/**
 * 销项业务单明细feign客户端
 *
 * @author ultraman
 * @date 2024-03-29
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcultramantongjunxian.entity.SalesBillDetailTjx;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-ultraman-tongjunxian")
public interface SalesBillDetailTjxFeignApi {

  /**
   * 通过id查询销项业务单明细
   * @param  id
   * @return R
   */
  @GetMapping("/salesBillDetailTjx/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增销项业务单明细
   * @param salesBillDetailTjx 销项业务单明细
   * @return R
   */
  @PostMapping("/salesBillDetailTjx/add")
  public R save(@RequestBody SalesBillDetailTjx salesBillDetailTjx);

  /**
   * 修改销项业务单明细
   * @param salesBillDetailTjx 销项业务单明细
   * @return R
   */
  @PostMapping("/salesBillDetailTjx/update")
  public R updateById(@RequestBody SalesBillDetailTjx salesBillDetailTjx);

  /**
   * 通过id删除销项业务单明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/salesBillDetailTjx/del/{id}" )
  public R removeById(@PathVariable Long id);

}