package com.xforceplus.jcultramantongjunxian.controller;


/**
 * 销项发票明细feign客户端
 *
 * @author ultraman
 * @date 2024-03-29
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcultramantongjunxian.entity.SellerInvoiceDetailsTjx;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-ultraman-tongjunxian")
public interface SellerInvoiceDetailsTjxFeignApi {

  /**
   * 通过id查询销项发票明细
   * @param  id
   * @return R
   */
  @GetMapping("/sellerInvoiceDetailsTjx/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增销项发票明细
   * @param sellerInvoiceDetailsTjx 销项发票明细
   * @return R
   */
  @PostMapping("/sellerInvoiceDetailsTjx/add")
  public R save(@RequestBody SellerInvoiceDetailsTjx sellerInvoiceDetailsTjx);

  /**
   * 修改销项发票明细
   * @param sellerInvoiceDetailsTjx 销项发票明细
   * @return R
   */
  @PostMapping("/sellerInvoiceDetailsTjx/update")
  public R updateById(@RequestBody SellerInvoiceDetailsTjx sellerInvoiceDetailsTjx);

  /**
   * 通过id删除销项发票明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/sellerInvoiceDetailsTjx/del/{id}" )
  public R removeById(@PathVariable Long id);

}