package com.xforceplus.jcultramantongjunxian.controller;


/**
 * 销项发票主信息feign客户端
 *
 * @author ultraman
 * @date 2024-03-29
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcultramantongjunxian.entity.SellerInvoiceMainTjx;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-ultraman-tongjunxian")
public interface SellerInvoiceMainTjxFeignApi {

  /**
   * 通过id查询销项发票主信息
   * @param  id
   * @return R
   */
  @GetMapping("/sellerInvoiceMainTjx/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增销项发票主信息
   * @param sellerInvoiceMainTjx 销项发票主信息
   * @return R
   */
  @PostMapping("/sellerInvoiceMainTjx/add")
  public R save(@RequestBody SellerInvoiceMainTjx sellerInvoiceMainTjx);

  /**
   * 修改销项发票主信息
   * @param sellerInvoiceMainTjx 销项发票主信息
   * @return R
   */
  @PostMapping("/sellerInvoiceMainTjx/update")
  public R updateById(@RequestBody SellerInvoiceMainTjx sellerInvoiceMainTjx);

  /**
   * 通过id删除销项发票主信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/sellerInvoiceMainTjx/del/{id}" )
  public R removeById(@PathVariable Long id);

}