package com.xforceplus.jcultramantongjunxian.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcultramantongjunxian.entity.BizOrderItem;
import com.xforceplus.jcultramantongjunxian.service.IBizOrderItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 业务单明细对象前端控制器
 *
 * @author ultraman
 * @date 2024-03-28
 */
@RestController
public class BizOrderItemController {

  @Autowired
  private IBizOrderItemService bizOrderItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizOrderItem 业务单明细对象
   * @return
   */
  @GetMapping("/bizorderitems" )
  public XfR getBizOrderItems(XfPage page, BizOrderItem bizOrderItem) {
    return XfR.ok(bizOrderItemServiceImpl.page(page, Wrappers.query(bizOrderItem)));
  }

  /**
   * 通过id查询业务单明细对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizorderitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizOrderItemServiceImpl.getById(id));
  }

  /**
   * 新增业务单明细对象
   * @param bizOrderItem 业务单明细对象
   * @return XfR
   */
  @PostMapping("/bizorderitems")
  public XfR save(@RequestBody BizOrderItem bizOrderItem) {
     return XfR.ok(bizOrderItemServiceImpl.save(bizOrderItem));
  }

  /**
   * 修改-传入修改后的全部数据业务单明细对象
   * @param bizOrderItem 业务单明细对象
   * @return XfR
   */
  @PutMapping("/bizorderitems/{id}")
  public XfR putUpdate(@RequestBody BizOrderItem bizOrderItem,@PathVariable Long id) {
      bizOrderItem.setId(id);
      return XfR.ok(bizOrderItemServiceImpl.updateById(bizOrderItem));
  }

  /**
   * 修改-传入修改的数据业务单明细对象
   * @param bizOrderItem 业务单明细对象
   * @return XfR
   */
  @PatchMapping("/bizorderitems/{id}")
  public XfR patchUpdate(@RequestBody BizOrderItem bizOrderItem,@PathVariable Long id) {
      BizOrderItem upbizOrderItem = bizOrderItemServiceImpl.getById(id);
      if(upbizOrderItem != null){
        upbizOrderItem = ObjectCopyUtils.copyProperties(bizOrderItem,upbizOrderItem,true);
      }
      return XfR.ok(bizOrderItemServiceImpl.updateById(upbizOrderItem));
  }

  /**
   * 通过id删除业务单明细对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizorderitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizOrderItemServiceImpl.removeById(id));
  }

  @PostMapping("/bizorderitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_order_item");
     params.put("request", condition);

     return XfR.ok(bizOrderItemServiceImpl.querys(params));
  }

}
