package com.xforceplus.jcultramanyinyue.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_type
 * </p>
 *
 * @author ultraman
 * @since 2024-04-02
 */
public enum InvoiceType {

    QS("qs", "数电专电"),
    QC("qc", "数电普电");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code){
        switch(code) {
            case "qs":
                return QS;
            case "qc":
                return QC;
            default:
                return null;
        }
    }
}
