package com.xforceplus.jcunilever.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2023-05-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.DeliveryRuleConfig;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-unilever")
public interface DeliveryRuleConfigFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/deliveryRuleConfig/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param deliveryRuleConfig ${table.comment}
   * @return R
   */
  @PostMapping("/deliveryRuleConfig/add")
  public R save(@RequestBody DeliveryRuleConfig deliveryRuleConfig);

  /**
   * 修改${table.comment}
   * @param deliveryRuleConfig ${table.comment}
   * @return R
   */
  @PostMapping("/deliveryRuleConfig/update")
  public R updateById(@RequestBody DeliveryRuleConfig deliveryRuleConfig);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/deliveryRuleConfig/del/{id}" )
  public R removeById(@PathVariable Long id);

}