package com.xforceplus.jcunilever.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2023-05-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.Mdm;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-unilever")
public interface MdmFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/mdm/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param mdm ${table.comment}
   * @return R
   */
  @PostMapping("/mdm/add")
  public R save(@RequestBody Mdm mdm);

  /**
   * 修改${table.comment}
   * @param mdm ${table.comment}
   * @return R
   */
  @PostMapping("/mdm/update")
  public R updateById(@RequestBody Mdm mdm);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/mdm/del/{id}" )
  public R removeById(@PathVariable Long id);

}