package com.xforceplus.jcunilever.controller;


/**
 * 结算池feign客户端
 *
 * @author ultraman
 * @date 2023-03-07
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.SettlementPool;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-unilever")
public interface SettlementPoolFeignApi {

  /**
   * 通过id查询结算池
   * @param  id
   * @return R
   */
  @GetMapping("/settlementPool/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增结算池
   * @param settlementPool 结算池
   * @return R
   */
  @PostMapping("/settlementPool/add")
  public R save(@RequestBody SettlementPool settlementPool);

  /**
   * 修改结算池
   * @param settlementPool 结算池
   * @return R
   */
  @PostMapping("/settlementPool/update")
  public R updateById(@RequestBody SettlementPool settlementPool);

  /**
   * 通过id删除结算池
   * @param  id
   * @return R
   */
  @DeleteMapping("/settlementPool/del/{id}" )
  public R removeById(@PathVariable Long id);

}