package com.xforceplus.jcunilever.controller;


/**
 * OTC业务feign客户端
 *
 * @author ultraman
 * @date 2023-12-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.MdmSync;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-unilever")
public interface MdmSyncFeignApi {

  /**
   * 通过id查询OTC业务
   * @param  id
   * @return R
   */
  @GetMapping("/mdmSync/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增OTC业务
   * @param mdmSync OTC业务
   * @return R
   */
  @PostMapping("/mdmSync/add")
  public R save(@RequestBody MdmSync mdmSync);

  /**
   * 修改OTC业务
   * @param mdmSync OTC业务
   * @return R
   */
  @PostMapping("/mdmSync/update")
  public R updateById(@RequestBody MdmSync mdmSync);

  /**
   * 通过id删除OTC业务
   * @param  id
   * @return R
   */
  @DeleteMapping("/mdmSync/del/{id}" )
  public R removeById(@PathVariable Long id);

}