package com.xforceplus.jcunilever.controller;


/**
 * OTC业务feign客户端
 *
 * @author ultraman
 * @date 2024-04-09
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.NoInvoicedReasonConfig;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-unilever")
public interface NoInvoicedReasonConfigFeignApi {

  /**
   * 通过id查询OTC业务
   * @param  id
   * @return R
   */
  @GetMapping("/noInvoicedReasonConfig/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增OTC业务
   * @param noInvoicedReasonConfig OTC业务
   * @return R
   */
  @PostMapping("/noInvoicedReasonConfig/add")
  public R save(@RequestBody NoInvoicedReasonConfig noInvoicedReasonConfig);

  /**
   * 修改OTC业务
   * @param noInvoicedReasonConfig OTC业务
   * @return R
   */
  @PostMapping("/noInvoicedReasonConfig/update")
  public R updateById(@RequestBody NoInvoicedReasonConfig noInvoicedReasonConfig);

  /**
   * 通过id删除OTC业务
   * @param  id
   * @return R
   */
  @DeleteMapping("/noInvoicedReasonConfig/del/{id}" )
  public R removeById(@PathVariable Long id);

}