package com.xforceplus.jcunilever.controller;


/**
 * CCMS申请单与红字确认单关系feign客户端
 *
 * @author ultraman
 * @date 2024-04-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.RedLetterNumberAndCcmsApplyNo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-unilever")
public interface RedLetterNumberAndCcmsApplyNoFeignApi {

  /**
   * 通过id查询CCMS申请单与红字确认单关系
   * @param  id
   * @return R
   */
  @GetMapping("/redLetterNumberAndCcmsApplyNo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增CCMS申请单与红字确认单关系
   * @param redLetterNumberAndCcmsApplyNo CCMS申请单与红字确认单关系
   * @return R
   */
  @PostMapping("/redLetterNumberAndCcmsApplyNo/add")
  public R save(@RequestBody RedLetterNumberAndCcmsApplyNo redLetterNumberAndCcmsApplyNo);

  /**
   * 修改CCMS申请单与红字确认单关系
   * @param redLetterNumberAndCcmsApplyNo CCMS申请单与红字确认单关系
   * @return R
   */
  @PostMapping("/redLetterNumberAndCcmsApplyNo/update")
  public R updateById(@RequestBody RedLetterNumberAndCcmsApplyNo redLetterNumberAndCcmsApplyNo);

  /**
   * 通过id删除CCMS申请单与红字确认单关系
   * @param  id
   * @return R
   */
  @DeleteMapping("/redLetterNumberAndCcmsApplyNo/del/{id}" )
  public R removeById(@PathVariable Long id);

}